# Formspree Integration Setup

This project uses Formspree to handle checkout form submissions.

## Setup Instructions

1. **Create a Formspree Account**
   - Go to https://formspree.io/
   - Sign up for a free account

2. **Create a New Form**
   - After logging in, click "New Form"
   - Give it a name (e.g., "seksi.bg Orders")
   - Copy the form endpoint URL (it will look like: `https://formspree.io/f/YOUR_FORM_ID`)

3. **Configure Environment Variable**
   - Create a `.env.local` file in the root of your project
   - Add the following line:
     ```
     NEXT_PUBLIC_FORMSPREE_ENDPOINT=https://formspree.io/f/YOUR_FORM_ID
     ```
   - Replace `YOUR_FORM_ID` with your actual Formspree form ID

4. **Restart Your Development Server**
   - Stop your current server (Ctrl+C)
   - Run `npm run dev` again to load the new environment variable

5. **Test the Integration**
   - Go to the checkout page
   - Fill out the form and submit an order
   - Check your Formspree dashboard to see the submission

## What Data is Sent

The checkout form sends the following information to Formspree:
- Customer name
- Email address
- Phone number
- Delivery option
- Delivery details (address or office name)
- Order comment (optional)
- Complete cart items list with sizes, colors, and prices
- Subtotal, delivery cost, and total amount

## Email Notifications

Formspree will send you an email notification for each order submission. You can also:
- View all submissions in your Formspree dashboard
- Set up webhooks to integrate with other services
- Configure auto-responders to send confirmation emails to customers

## Troubleshooting

- **Form not submitting**: Check that your `NEXT_PUBLIC_FORMSPREE_ENDPOINT` environment variable is set correctly
- **Not receiving emails**: Check your Formspree account settings and spam folder
- **CORS errors**: Make sure you're using the correct Formspree endpoint URL format

